﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class PromoCodesBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static PromoCodes GetItem(Guid productCodeID, string promoCode, string keyword)
        {
            return PromoCodesDB.GetItem(productCodeID, promoCode, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<PromoCodes> GetList(Guid productCodeID, string promoCode, string keyword)
        {
            return PromoCodesDB.GetList(productCodeID, promoCode, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid productCodeID, string promoCode, string keyword)
        {
            return PromoCodesDB.GetDataTable(productCodeID, promoCode, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid productCodeID, string promoCode, string keyword)
        {
            return PromoCodesDB.GetDataSet(productCodeID, promoCode, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(PromoCodes myPromoCodes)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                PromoCodesDB.Save(myPromoCodes);

                myTransactionScope.Complete();
                return true;
            }
        }
    }
}
